/*******************************************************************
/*  DiskRecUnit.h
/*  Author: Vadim Berman
/*
/*  Description:
/*  declaration of non-member functions used to load data composed in
/*  Data Manager
/*
/*  The contents of this file are subject to the Brainiac Public License.
/*  Version 1.0 (the "License"); you may not use this file except in
/*  compliance with the License. You may obtain a copy of the License at
/*  http://www.twilightminds.com
/*
/*  Software distributed under the License is distributed on an "AS IS"
/*  basis WITHOUT WARRANTY OF ANY KIND, either express or implied. See
/*  the License for the specific language governing rights and limitations
/*  under the License.
/*
/*  Copyright (C) 1999 Twilight Minds. All rights reserved.
/********************************************************************/
//---------------------------------------------------------------------------
#ifndef DiskRecUnitH
#define DiskRecUnitH
#include "CommonUnit.h"
//---------------------------------------------------------------------------
typedef enum { UNDEFINED = 0, VERBAL = 1, COMMERCIAL = 2, MECHANIC = 3,
        VITAL = 4, STRATEGY_CALL = 5 }
	ActionType;


//--------------------------------------------------------------------------
//--- auxiliary data types and various service functions for reading files -
//--------------------------------------------------------------------------

typedef struct {
	unsigned char GoalItself;
    unsigned char GoalImportance;
    unsigned char CompType;
    //comparison: absolute, relative to this, relative to that, ...
    unsigned char AllowedEnvironment;
    unsigned char IdFlag1;
    unsigned short IdFlag2;
    signed short LWickedness,HWickedness, LAnarchy, HAnarchy;
    signed short LAtt2Eval,HAtt2Eval,LAttByEval,HAttByEval,
        LAtt2StrObj,HAtt2StrObj,LAttByStrObj,HAttByStrObj,
        LAtt2LastInit,HAtt2LastInit,LAttByLastInit,HAttByLastInit,
        LAtt2RefActObj,HAtt2RefActObj,LAttByRefActObj,
        HAttByRefActObj,AttRefAct,LUserDefAtt,HUserDefAtt,
        UserDefAttId;
	signed short LMeanness,HMeanness,LSeemMean,HSeemMean,LWealth,HWealth,
        LSeemWeal,HSeemWeal,LBeauty,HBeauty,LSeemInt,HSeemInt,
        LForeignness, HForeignness,
        LIntelligence, HIntelligence, LCourage, HCourage;
    char Descr[GOAL_DESC_LEN];
    char Unused[26];    //reserved for further expansions
    unsigned short IncGoalID;
    unsigned char AttDir, Dead;
    signed short LUser1,HUser1,LUser2,HUser2,LUser3,HUser3;
    char IsDeleted;
} GoalFileRec;
void BBECALL Buf2GoalRec(BYTE *,GoalFileRec & );

typedef struct {
	unsigned short ActionID;
    char Verb[VERB_LEN];
    ActionType AType;   //maybe, enum is in fact int and not a byte???
    //char AType;
    signed short AttitudeChange;
    unsigned char FModule;
    char FunctionLabel[FUNCTION_LEN];
    unsigned char MinIntel, ReqCourage, Difficulty;
	signed short Wickedness, Anarchy;
    signed short MinAttitude,MaxAttitude;
    char Reserved[20];
    char IsDeleted;
} ActFileRec;
void BBECALL Buf2ActRec(BYTE *,ActFileRec &);

typedef struct {
	unsigned short StrategyID;
    char StrategyName[STR_NAME_LEN];
    char Descr[STR_DESC_LEN];
    unsigned char GoalItself;
    unsigned char GoalImportance;
    unsigned char MaxIntel;
    struct _ActInStr {
        unsigned short ActionIDs;
        unsigned char TAC;  //TAC stands for TargetAssignmentCriteria
        unsigned char ReferencedTAC;
        unsigned char ConditionalGoto;
    } Actions[99];
    unsigned char _Type;
    unsigned char MiscFlags[4];
    char IsDeleted;
} StrFileRec;
void BBECALL Buf2StrRec(BYTE *,StrFileRec&);

//---------------------------------------------------------------------------
//  GoalDefNode is defined in common.h unit
//
//---------------------------------------------------------------------------
struct _ActionDefNode {
	ID ActionID;
    char Verb[ACT_DESC_LEN];
    int (BBECALL *ActionFn)(void*);
    ID ModNum;
    ActionType _Type;
    percentage Difficulty;
    percentage Wickedness, Anarchy;
    percentage AttitudeChange;
    	//not effective change, but a multiplier
    	//of AttitudeChangeUnit
    	// ******** "solid" scores ********
    percentage MinIntel, ReqCourage, MinAttitude, MaxAttitude;
	struct _ActionDefNode *next;
};
typedef struct _ActionDefNode* ActionDefNodeP;
//---------------------------------------------------------------------------

struct _StrategyDefNode {
	ID StrategyID;
    char Name[STR_NAME_LEN],Descr[STR_DESC_LEN];
    Goal TheGoal;
    percentage MaxIntel;
    unsigned char _Type;
    ID ActionsNo;
    //dynamic array
    ID *ActionIDs;
    unsigned char *TACs;
    unsigned char *ReferencedTACs;
    unsigned char *ConditionalGoto;
    unsigned char *Verbal1Ind, *Verbal2Ind;
    //the 2 last are indices that hold verbal actions' contents

    ID *Verbal1;
    unsigned char *Verbal1TACs;
    unsigned char *v1ReferencedTACs;
    unsigned char *v1ConditionalGoto;
    ID *Verbal2;
    unsigned char *Verbal2TACs;
    unsigned char *v2ReferencedTACs;
    unsigned char *v2ConditionalGoto;
	struct _StrategyDefNode *next;
};
typedef struct _StrategyDefNode* StrategyDefNodeP;

BOOL BBECALL AddNewGoalNode(GoalFileRec);
BOOL BBECALL AddNewActNode(ActFileRec,int(BBECALL *)(void*));
BOOL BBECALL AddDummyActNode(); //adding "same" action
BOOL BBECALL AddNewStrNode(StrFileRec);
unsigned short BBECALL QuickDiffCalc(StrategyDefNodeP);
EXPO ActionDefNodeP   BBECALL GetActionNode(ID);
EXPO StrategyDefNodeP BBECALL GetStrategyNode(ID);
EXPO GoalDefNodeP     BBECALL GetGoalNode(ID);
EXPO ActionDefNodeP   BBECALL LinkFnToAction(ID, int (BBECALL *)(void*));

//---------------------------------------------------------------------------
typedef struct {
    BYTE ParGroup;
    ID ModuleID;
    char szModuleName[MAX_MODULE_NAME];
    BYTE IsDeleted;
} ModuleRec;
BOOL BBECALL Buf2ModRec(BYTE *,ModuleRec&);

typedef struct{
    HMODULE hMod;
    ID ModId;
}   ModuleEntry;

BOOL BBECALL AddNewModuleNode(ModuleRec&, ID );

//---------------------------------------------------------------------------
typedef struct {
    unsigned short MindID;
    char Descr[MIND_DESC_LEN];
    short LWick,HWick,LAnar,HAnar,InitialAttitude;
    unsigned char AttitudeChangeUnit,SuddenChangeProb;
    short InflMean,InflMeanDiff,InflBeau,InflBeauDiff,InflWeal,
            InflWealDiff,InflInt,InflIntDiff,InflSocGrpDiff,
            ItemInflMean,ItemInflBeau,ItemInflWeal,
            ItemInflIntel;
    char Reserved[30];
    unsigned char IsDeleted;
} MindFileRec;
void BBECALL Buf2MindRec(BYTE *,MindFileRec & );
BOOL BBECALL AddNewMindNode(MindFileRec);
EXPO MindDefNodeP BBECALL GetMindNode(ID);
EXPO char *       BBECALL GetMindDesc(ID);
EXPO MindDefNodeP BBECALL GetMatchMindNode(percentage,percentage);
EXPO int          BBECALL FillBufferWithMindPtrs(MindDefNodeP *,int = 0xFFFF);
EXPO int          BBECALL FillBufferWithActionPtrs(ActionDefNodeP *, int = 0xFFFF);
//---------------------------------------------------------------------------

#endif

